/**************************************************************************
* PROJECT: Interrupts in Decoupled Parallel Mode for MPC5675K	          * 
* FILE NAME: GHS_MPC56xx_55xx_FLASH.ld                                    *
* DESCRIPTION:                                                            *
*        This is a single project, single entry point dual core           *
*	 application that performs parallel processing tasks using a      *
*        single re-entrant sub-routine.
*=========================================================================*
*                                                                         *
* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                  *
* ---   -----------   ----------   ---------------------                  *
* 1.0:  Sim, Mong Tee 12/Feb/10    Initial version                        *
* 1.1:  T. Kulig      20/Feb/12    Modified            			  *
***************************************************************************/
/*  LICENSE: 
 *  Copyright (c) 2012 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
***************************************************************************/
 
DEFAULTS
{
        // Flash Device Definition
        FLASH_SIZE          = 1M                        
        FLASH_BASE_ADDR     = 0x0000000

        // RCHW Located at beginning of flash  

        // SRAM Device Definition
        SRAM_SIZE           = 256k        
        SRAM_BASE0_ADDR     = 0x40000000     
        SRAM_BASE1_ADDR     = 0x50000000   
      
        // Stack located at end of SRAM        
        STACK_SIZE0         = 4K                                                // 4KB Stack for core 0
        STACK_SIZE1         = 4k                                                // 4KB Stack for core 1
}


MEMORY
{
        flash_rcw  : org = FLASH_BASE_ADDR,                                     len = 8
        int_flash  : org = FLASH_BASE_ADDR+8,                                   len = FLASH_SIZE-8
        int_sram   : org = SRAM_BASE0_ADDR,                                     len = SRAM_SIZE - STACK_SIZE0 - STACK_SIZE1 
        stack_ram0 : org = (SRAM_BASE0_ADDR+SRAM_SIZE-STACK_SIZE0)  		len = STACK_SIZE0
        stack_ram1 : org = (SRAM_BASE1_ADDR+SRAM_SIZE-STACK_SIZE1)              len = STACK_SIZE1
}

SECTIONS
{
    .rcw                                               	: > flash_rcw

    .text                                               : > int_flash           // BookE Code    
    .vletext                                            : > .                   // VLE Code  
    .syscall                                            : > .                   // code                  
    .rodata                                             : > .                   // Read Only Data
    
    .isrvectbl    ALIGN(0x800)              		: > .			// ISR Vector Table - must be 2K aligned
    .isrvectbl1    ALIGN(0x800)              		: > . 			// ISR Vector Table - must be 2K aligned 
    .xptn_vectors ALIGN(0x10000)             		: > .			// Exception Vector Table (IVPR) - align 64K boundary
    .xptn_vectors1 ALIGN(0x10000)             		: > .			// Exception Vector Table (IVPR) - align 64K boundary  
    .sdata2                                             : > .

    .secinfo                                            : > .			// GHS provided startup  
    .fixaddr                                            : > .			// Required for          
    .fixtype                                            : > .			// compatibility with    

    .ROM.data   ROM(.data)                  		: > .			// Store Initialised RAM Variables
    .ROM.sdata  ROM(.sdata)                 		: > .			// temporarily in Flash             

    .sdata                                  		: {} > int_sram		// Small Initialised Data (Area1)   
    .sbss                                   		: {} > .		// Small Uninitialised Data (Area1) 
    .data                                   		: {} > .
    .bss                                    		: {} > .
 
    .heap   ALIGN(16) PAD(4K)               		: {} > .		// Heap Area   
    .stack0 ALIGN(4)  PAD(STACK_SIZE0)      		: {} > stack_ram0	// Stack Area  
    .stack1 ALIGN(4)  PAD(STACK_SIZE1)      		: {} > stack_ram1	// Stack Area  

 
        __SP_INIT0              = ADDR(.stack0) + SIZEOF(stack_ram0);
        __SP_INIT1              = ADDR(.stack1) + SIZEOF(stack_ram1);
  
        __IVPR                  = ADDR(.xptn_vectors);                          // Interrupt Handler Parameters
	__IVPR1			= ADDR(.xptn_vectors1);					// what should the second core do?
        
        __DATA_SRAM_ADDR        = ADDR(.data);                                  // Labels for Copying Initialised  
        __SDATA_SRAM_ADDR       = ADDR(.sdata);                                 // Data from Flash to RAM  
   
        __DATA_SIZE   = SIZEOF(.data);
        __SDATA_SIZE            = SIZEOF(.sdata);

	__DATA_ROM_ADDR  = ADDR(.ROM.data);
	__SDATA_ROM_ADDR = ADDR(.ROM.sdata);

         
        _SRAM_SIZE              = SRAM_SIZE;                                    // Labels Used for Initialising SRAM ECC
        _SRAM_BASE0_ADDR        = SRAM_BASE0_ADDR;
        _SRAM_BASE1_ADDR        = SRAM_BASE1_ADDR;

        // These special symbols mark the bounds of RAM and ROM memory.  
        // They are used by the MULTI debugger.                          

        __ghs_ramstart          = MEMADDR    (int_sram);
        __ghs_ramend            = MEMENDADDR (int_sram);
        
        __ghs_romstart          = MEMADDR    (int_flash);
        __ghs_romend            = MEMENDADDR (int_flash);

        // RAM code
        __ghs_rambootcodestart  = 0;                                            // zero for ROM image  
        __ghs_rambootcodeend    = 0;                                            // zero for ROM image  

        // ROM code
        __ghs_rombootcodestart  = MEMADDR    (int_flash);
        __ghs_rombootcodeend    = MEMENDADDR (int_flash);

}



